/** @file   lightfencemanager.h
 * @brief   Declaration of LightFenceManager - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_LIGHTFENCEMANAGER_H
#define H_ENG2D_LIGHTFENCEMANAGER_H

#include <vector>
#include "eng2d_dll.h"
#include "lightfence.h"

namespace eng2d {

/** @class  LightFenceManager
 * @brief   Manages the light fences.
 * @author  Tomi Lamminsaari
 *
 */
class DLLIMPORT LightFenceManager
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	LightFenceManager();


	/** Destructor
   */
	virtual ~LightFenceManager();

private:

	/** Copy constructor.
   * @param     rO                Reference to another LightFenceManager
   */
  LightFenceManager( const LightFenceManager& rO );

	/** Assignment operator
   * @param     rO                Reference to another LightFenceManager
   * @return    Reference to us.
   */
  LightFenceManager& operator = ( const LightFenceManager& rO );

public:


  ///
  /// Methods
  /// =======

  /** Adds new LightFence
   * @param     pLF               Pointer to new LightFence being added.
   */
  void addLightFence( LightFence* pLF );

  /** Destroyes all the light fences.
   */
  void clear();
  
  /** Updates all the light fences
   */
  void update();
  
  /** Draws the light fences.
   * @param     pB                Pointer to target bitmap.
   * @param     offset            An offset for translating the fences
   *                              from world-coordinates to screen
   *                              coordinates.
   */
  void redraw( BITMAP* pB, const Vec2D& offset );
  

  ///
  /// Getter methods
  /// ==============

  /** Returns the number of lightfences there are.
   * @return    Number of lightfences.
   */
  int fenceCount() const;

  /** Returns a pointer to index'th fence.
   * @param     fenceIndex        Index of the fence
   * @return    Pointer to fence or nullpointer if there is no fence
   *            on such index.
   */
  LightFence* getFence( int fenceIndex ) const;
  
  /** Returns the LightFence that touches the given point.
   * @param     rP                The point
   * @param     dist              The maximum distance that still touches
   * @return    Pointer to first LightFence that touches the point or
   *            nullpointer if there is no touch.
   */
  LightFence* lightfenceTouch( const Vec2D& rP, float dist ) const;

protected:

  ///
  /// Members
  /// =======

  /** The lightfences are stored here. */
  std::vector< LightFence* >  m_fences;


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif
